/*
 * registry.c
 *
 *  Created on: Jan 2, 2021
 *      Author: ianst
 */
#include "registry.h"
#include "scheduler.h"
#include "setup.h"
#include "main.h"
#include "stdint.h"
#include <string.h>
#include "stm32f4xx.h"
#include "config.h"
#include "TCPIPConfig.h"
#include "ianENC28J60.h"
#include "armbits.h"



extern char __attribute__((aligned(4))) Screen[SCREEN_ROWS*SCREEN_COLS];
extern uint8_t __attribute__((aligned(4))) DMA_Buffer_0[DMA_Buffer_0_Size];
uint8_t __attribute__((aligned(4))) ADC_DMA_Buffer[ADC_DMA_Buffer_Size];
uint8_t __attribute__((aligned(4))) DAC_DMA_Buffer[DAC_DMA_Buffer_Size];

const DMAC_TypeDef  dma1 ={(DMA_TypeDef*) (DMA1_BASE),
					(DMA_Stream_TypeDef *)DMA1_Stream0_BASE,
					(DMA_Stream_TypeDef *)DMA1_Stream1_BASE,
					(DMA_Stream_TypeDef *)DMA1_Stream2_BASE,
					(DMA_Stream_TypeDef *)DMA1_Stream3_BASE,
					(DMA_Stream_TypeDef *)DMA1_Stream4_BASE,
					(DMA_Stream_TypeDef *)DMA1_Stream5_BASE,
					(DMA_Stream_TypeDef *)DMA1_Stream6_BASE,
					(DMA_Stream_TypeDef *)DMA1_Stream7_BASE
};

const DMAC_TypeDef  dma2 ={(DMA_TypeDef *)DMA2_BASE,
					(DMA_Stream_TypeDef *)DMA2_Stream0_BASE,
					(DMA_Stream_TypeDef *)DMA2_Stream1_BASE,
					(DMA_Stream_TypeDef *)DMA2_Stream2_BASE,
					(DMA_Stream_TypeDef *)DMA2_Stream3_BASE,
					(DMA_Stream_TypeDef *)DMA2_Stream4_BASE,
					(DMA_Stream_TypeDef *)DMA2_Stream5_BASE,
					(DMA_Stream_TypeDef *)DMA2_Stream6_BASE,
					(DMA_Stream_TypeDef *)DMA2_Stream7_BASE
};

//Test variables

int8_t  Test_sint8[6]={0,1,2,3,4,5};
uint8_t Test_uint8[6]={0,1,2,3,4,5};
int16_t Test_sint16le[6]={0,1,2,3,4,5};
uint16_t Test_uint16le[6]={0,1,2,3,4,5};
int32_t Test_sint32le[6]={0,1,2,3,4,5};
uint32_t Test_uint32le[6]={0,1,2,3,4,5};
float Test_float32le[6]={0.0, 1.0, 2.0, 3.0, 4.0, 5.0};
float ADC1_CAL={5.0546605e-05};

const char  Reg_Name[40] =  __DATE__ __TIME__;
const RegEnt Reg_End	={(void *)0,0,0 ,0,T_null,"Reg_End                   "};


//Put your registry entries here


REGENTS(SysTick->CTRL,SysTick_CTRL,End	,T_uint32le,1);
REGENTS(SysTick->LOAD,SysTick_LOAD,SysTick_CTRL	,T_uint32le,1);
REGENTS(SysTick->VAL ,SysTick_VAL,SysTick_LOAD	,T_uint32le,1);
REGENTS(SysTick->CALIB,SysTick_CALIB,SysTick_VAL	,T_uint32le,1);

REGENTS(GPIOA->MODER,GPIOA_MODER,SysTick_CALIB	,T_uint32le,1);
REGENTS(GPIOA->OTYPER,GPIOA_OTYPER,GPIOA_MODER	,T_uint32le,1);
REGENTS(GPIOA->OSPEEDR,GPIOA_OSPEEDR,GPIOA_OTYPER	,T_uint32le,1);
REGENTS(GPIOA->PUPDR,GPIOA_PUPDR,GPIOA_OSPEEDR	,T_uint32le,1);
REGENTS(GPIOA->IDR,GPIOA_IDR,GPIOA_PUPDR	,T_uint32le,1);
REGENTS(GPIOA->ODR,GPIOA_ODR,GPIOA_IDR	,T_uint32le,1);
REGENTS(GPIOA->BSRR,GPIOA_BSRR,GPIOA_ODR	,T_uint32le,1);
REGENTS(GPIOA->LCKR,GPIOA_LCKR,GPIOA_BSRR	,T_uint32le,1);
REGENTS(GPIOA->AFR[0],GPIOA_AFR0,GPIOA_LCKR	,T_uint32le,1);
REGENTS(GPIOA->AFR[1],GPIOA_AFR1,GPIOA_AFR0	,T_uint32le,1);

REGENTS(GPIOB->MODER,GPIOB_MODER,GPIOA_AFR1	,T_uint32le,1);
REGENTS(GPIOB->OTYPER,GPIOB_OTYPER,GPIOB_MODER	,T_uint32le,1);
REGENTS(GPIOB->OSPEEDR,GPIOB_OSPEEDR,GPIOB_OTYPER	,T_uint32le,1);
REGENTS(GPIOB->PUPDR,GPIOB_PUPDR,GPIOB_OSPEEDR	,T_uint32le,1);
REGENTS(GPIOB->IDR,GPIOB_IDR,GPIOB_PUPDR	,T_uint32le,1);
REGENTS(GPIOB->ODR,GPIOB_ODR,GPIOB_IDR	,T_uint32le,1);
REGENTS(GPIOB->BSRR,GPIOB_BSRR,GPIOB_ODR	,T_uint32le,1);
REGENTS(GPIOB->LCKR,GPIOB_LCKR,GPIOB_BSRR	,T_uint32le,1);
REGENTS(GPIOB->AFR[0],GPIOB_AFR0,GPIOB_LCKR	,T_uint32le,1);
REGENTS(GPIOB->AFR[1],GPIOB_AFR1,GPIOB_AFR0	,T_uint32le,1);

REGENTS(GPIOC->MODER,GPIOC_MODER,GPIOB_AFR1	,T_uint32le,1);
REGENTS(GPIOC->OTYPER,GPIOC_OTYPER,GPIOC_MODER	,T_uint32le,1);
REGENTS(GPIOC->OSPEEDR,GPIOC_OSPEEDR,GPIOC_OTYPER	,T_uint32le,1);
REGENTS(GPIOC->PUPDR,GPIOC_PUPDR,GPIOC_OSPEEDR	,T_uint32le,1);
REGENTS(GPIOC->IDR,GPIOC_IDR,GPIOC_PUPDR	,T_uint32le,1);
REGENTS(GPIOC->ODR,GPIOC_ODR,GPIOC_IDR	,T_uint32le,1);
REGENTS(GPIOC->BSRR,GPIOC_BSRR,GPIOC_ODR	,T_uint32le,1);
REGENTS(GPIOC->LCKR,GPIOC_LCKR,GPIOC_BSRR	,T_uint32le,1);
REGENTS(GPIOC->AFR[0],GPIOC_AFR0,GPIOC_LCKR	,T_uint32le,1);
REGENTS(GPIOC->AFR[1],GPIOC_AFR1,GPIOC_AFR0	,T_uint32le,1);

REGENTS(GPIOD->MODER,GPIOD_MODER,GPIOC_AFR1	,T_uint32le,1);
REGENTS(GPIOD->OTYPER,GPIOD_OTYPER,GPIOD_MODER	,T_uint32le,1);
REGENTS(GPIOD->OSPEEDR,GPIOD_OSPEEDR,GPIOD_OTYPER	,T_uint32le,1);
REGENTS(GPIOD->PUPDR,GPIOD_PUPDR,GPIOD_OSPEEDR	,T_uint32le,1);
REGENTS(GPIOD->IDR,GPIOD_IDR,GPIOD_PUPDR	,T_uint32le,1);
REGENTS(GPIOD->ODR,GPIOD_ODR,GPIOD_IDR	,T_uint32le,1);
REGENTS(GPIOD->BSRR,GPIOD_BSRR,GPIOD_ODR	,T_uint32le,1);
REGENTS(GPIOD->LCKR,GPIOD_LCKR,GPIOD_BSRR	,T_uint32le,1);
REGENTS(GPIOD->AFR[0],GPIOD_AFR0,GPIOD_LCKR	,T_uint32le,1);
REGENTS(GPIOD->AFR[1],GPIOD_AFR1,GPIOD_AFR0	,T_uint32le,1);

REGENTS(GPIOE->MODER,GPIOE_MODER,GPIOD_AFR1	,T_uint32le,1);
REGENTS(GPIOE->OTYPER,GPIOE_OTYPER,GPIOE_MODER	,T_uint32le,1);
REGENTS(GPIOE->OSPEEDR,GPIOE_OSPEEDR,GPIOE_OTYPER	,T_uint32le,1);
REGENTS(GPIOE->PUPDR,GPIOE_PUPDR,GPIOE_OSPEEDR	,T_uint32le,1);
REGENTS(GPIOE->IDR,GPIOE_IDR,GPIOE_PUPDR	,T_uint32le,1);
REGENTS(GPIOE->ODR,GPIOE_ODR,GPIOE_IDR	,T_uint32le,1);
REGENTS(GPIOE->BSRR,GPIOE_BSRR,GPIOE_ODR	,T_uint32le,1);
REGENTS(GPIOE->LCKR,GPIOE_LCKR,GPIOE_BSRR	,T_uint32le,1);
REGENTS(GPIOE->AFR[0],GPIOE_AFR0,GPIOE_LCKR	,T_uint32le,1);
REGENTS(GPIOE->AFR[1],GPIOE_AFR1,GPIOE_AFR0	,T_uint32le,1);

REGENTS(TIM1->CR1,TIM1_CR1,GPIOE_AFR1	,T_uint32le,1);
REGENTS(TIM1->CR2,TIM1_CR2,TIM1_CR1	,T_uint32le,1);
REGENTS(TIM1->SMCR,TIM1_SMCR,TIM1_CR2	,T_uint32le,1);
REGENTS(TIM1->DIER,TIM1_DIER,TIM1_SMCR	,T_uint32le,1);
REGENTS(TIM1->SR,TIM1_SR,TIM1_DIER	,T_uint32le,1);
REGENTS(TIM1->EGR,TIM1_EGR, TIM1_SR	,T_uint32le,1);
REGENTS(TIM1->CCMR1,TIM1_CCMR1, TIM1_EGR ,T_uint32le,1);
REGENTS(TIM1->CCMR2,TIM1_CCMR2, TIM1_CCMR1 ,T_uint32le,1);
REGENTS(TIM1->CCER,TIM1_CCER, TIM1_CCMR2 ,T_uint32le,1);
REGENTS(TIM1->CNT,TIM1_CNT, TIM1_CCER ,T_uint32le,1);
REGENTS(TIM1->PSC,TIM1_PSC, TIM1_CNT ,T_uint32le,1);
REGENTS(TIM1->ARR,TIM1_ARR, TIM1_PSC ,T_uint32le,1);
REGENTS(TIM1->CCR1,TIM1_CCR1, TIM1_ARR ,T_uint32le,1);
REGENTS(TIM1->CCR2,TIM1_CCR2, TIM1_CCR1 ,T_uint32le,1);
REGENTS(TIM1->CCR3,TIM1_CCR3, TIM1_CCR2 ,T_uint32le,1);
REGENTS(TIM1->CCR4,TIM1_CCR4, TIM1_CCR3 ,T_uint32le,1);
REGENTS(TIM1->BDTR,TIM1_BDTR, TIM1_CCR4 ,T_uint32le,1);
REGENTS(TIM1->DCR,TIM1_DCR, TIM1_BDTR ,T_uint32le,1);
REGENTS(TIM1->DMAR,TIM1_DMAR, TIM1_DCR ,T_uint32le,1);
REGENTS(TIM1->OR,TIM1_OR, TIM1_DMAR ,T_uint32le,1);

REGENTS(TIM2->CR1,TIM2_CR1,TIM1_OR	,T_uint32le,1);
REGENTS(TIM2->CR2,TIM2_CR2,TIM2_CR1	,T_uint32le,1);
REGENTS(TIM2->SMCR,TIM2_SMCR,TIM2_CR2	,T_uint32le,1);
REGENTS(TIM2->DIER,TIM2_DIER,TIM2_SMCR	,T_uint32le,1);
REGENTS(TIM2->SR,TIM2_SR,TIM2_DIER	,T_uint32le,1);
REGENTS(TIM2->EGR,TIM2_EGR, TIM2_SR	,T_uint32le,1);
REGENTS(TIM2->CCMR1,TIM2_CCMR1, TIM2_EGR ,T_uint32le,1);
REGENTS(TIM2->CCMR2,TIM2_CCMR2, TIM2_CCMR1 ,T_uint32le,1);
REGENTS(TIM2->CCER,TIM2_CCER, TIM2_CCMR2 ,T_uint32le,1);
REGENTS(TIM2->CNT,TIM2_CNT, TIM2_CCER ,T_uint32le,1);
REGENTS(TIM2->PSC,TIM2_PSC, TIM2_CNT ,T_uint32le,1);
REGENTS(TIM2->ARR,TIM2_ARR, TIM2_PSC ,T_uint32le,1);
REGENTS(TIM2->CCR1,TIM2_CCR1, TIM2_ARR ,T_uint32le,1);
REGENTS(TIM2->CCR2,TIM2_CCR2, TIM2_CCR1 ,T_uint32le,1);
REGENTS(TIM2->CCR3,TIM2_CCR3, TIM2_CCR2 ,T_uint32le,1);
REGENTS(TIM2->CCR4,TIM2_CCR4, TIM2_CCR3 ,T_uint32le,1);
REGENTS(TIM2->BDTR,TIM2_BDTR, TIM2_CCR4 ,T_uint32le,1);
REGENTS(TIM2->DCR,TIM2_DCR, TIM2_BDTR ,T_uint32le,1);
REGENTS(TIM2->DMAR,TIM2_DMAR, TIM2_DCR ,T_uint32le,1);
REGENTS(TIM2->OR,TIM2_OR, TIM2_DMAR ,T_uint32le,1);

REGENTS(TIM3->CR1,TIM3_CR1,TIM2_OR	,T_uint32le,1);
REGENTS(TIM3->CR2,TIM3_CR2,TIM3_CR1	,T_uint32le,1);
REGENTS(TIM3->SMCR,TIM3_SMCR,TIM3_CR2	,T_uint32le,1);
REGENTS(TIM3->DIER,TIM3_DIER,TIM3_SMCR	,T_uint32le,1);
REGENTS(TIM3->SR,TIM3_SR,TIM3_DIER	,T_uint32le,1);
REGENTS(TIM3->EGR,TIM3_EGR, TIM3_SR	,T_uint32le,1);
REGENTS(TIM3->CCMR1,TIM3_CCMR1, TIM3_EGR ,T_uint32le,1);
REGENTS(TIM3->CCMR2,TIM3_CCMR2, TIM3_CCMR1 ,T_uint32le,1);
REGENTS(TIM3->CCER,TIM3_CCER, TIM3_CCMR2 ,T_uint32le,1);
REGENTS(TIM3->CNT,TIM3_CNT, TIM3_CCER ,T_uint32le,1);
REGENTS(TIM3->PSC,TIM3_PSC, TIM3_CNT ,T_uint32le,1);
REGENTS(TIM3->ARR,TIM3_ARR, TIM3_PSC ,T_uint32le,1);
REGENTS(TIM3->CCR1,TIM3_CCR1, TIM3_ARR ,T_uint32le,1);
REGENTS(TIM3->CCR2,TIM3_CCR2, TIM3_CCR1 ,T_uint32le,1);
REGENTS(TIM3->CCR3,TIM3_CCR3, TIM3_CCR2 ,T_uint32le,1);
REGENTS(TIM3->CCR4,TIM3_CCR4, TIM3_CCR3 ,T_uint32le,1);
REGENTS(TIM3->BDTR,TIM3_BDTR, TIM3_CCR4 ,T_uint32le,1);
REGENTS(TIM3->DCR,TIM3_DCR, TIM3_BDTR ,T_uint32le,1);
REGENTS(TIM3->DMAR,TIM3_DMAR, TIM3_DCR ,T_uint32le,1);
REGENTS(TIM3->OR,TIM3_OR, TIM3_DMAR ,T_uint32le,1);

REGENTS(TIM4->CR1,TIM4_CR1,TIM3_OR	,T_uint32le,1);
REGENTS(TIM4->CR2,TIM4_CR2,TIM4_CR1	,T_uint32le,1);
REGENTS(TIM4->SMCR,TIM4_SMCR,TIM4_CR2	,T_uint32le,1);
REGENTS(TIM4->DIER,TIM4_DIER,TIM4_SMCR	,T_uint32le,1);
REGENTS(TIM4->SR,TIM4_SR,TIM4_DIER	,T_uint32le,1);
REGENTS(TIM4->EGR,TIM4_EGR, TIM4_SR	,T_uint32le,1);
REGENTS(TIM4->CCMR1,TIM4_CCMR1, TIM4_EGR ,T_uint32le,1);
REGENTS(TIM4->CCMR2,TIM4_CCMR2, TIM4_CCMR1 ,T_uint32le,1);
REGENTS(TIM4->CCER,TIM4_CCER, TIM4_CCMR2 ,T_uint32le,1);
REGENTS(TIM4->CNT,TIM4_CNT, TIM4_CCER ,T_uint32le,1);
REGENTS(TIM4->PSC,TIM4_PSC, TIM4_CNT ,T_uint32le,1);
REGENTS(TIM4->ARR,TIM4_ARR, TIM4_PSC ,T_uint32le,1);
REGENTS(TIM4->CCR1,TIM4_CCR1, TIM4_ARR ,T_uint32le,1);
REGENTS(TIM4->CCR2,TIM4_CCR2, TIM4_CCR1 ,T_uint32le,1);
REGENTS(TIM4->CCR3,TIM4_CCR3, TIM4_CCR2 ,T_uint32le,1);
REGENTS(TIM4->CCR4,TIM4_CCR4, TIM4_CCR3 ,T_uint32le,1);
REGENTS(TIM4->BDTR,TIM4_BDTR, TIM4_CCR4 ,T_uint32le,1);
REGENTS(TIM4->DCR,TIM4_DCR, TIM4_BDTR ,T_uint32le,1);
REGENTS(TIM4->DMAR,TIM4_DMAR, TIM4_DCR ,T_uint32le,1);
REGENTS(TIM4->OR,TIM4_OR, TIM4_DMAR ,T_uint32le,1);

REGENTS(TIM5->CR1,TIM5_CR1,TIM4_OR	,T_uint32le,1);
REGENTS(TIM5->CR2,TIM5_CR2,TIM5_CR1	,T_uint32le,1);
REGENTS(TIM5->SMCR,TIM5_SMCR,TIM5_CR2	,T_uint32le,1);
REGENTS(TIM5->DIER,TIM5_DIER,TIM5_SMCR	,T_uint32le,1);
REGENTS(TIM5->SR,TIM5_SR,TIM5_DIER	,T_uint32le,1);
REGENTS(TIM5->EGR,TIM5_EGR, TIM5_SR	,T_uint32le,1);
REGENTS(TIM5->CCMR1,TIM5_CCMR1, TIM5_EGR ,T_uint32le,1);
REGENTS(TIM5->CCMR2,TIM5_CCMR2, TIM5_CCMR1 ,T_uint32le,1);
REGENTS(TIM5->CCER,TIM5_CCER, TIM5_CCMR2 ,T_uint32le,1);
REGENTS(TIM5->CNT,TIM5_CNT, TIM5_CCER ,T_uint32le,1);
REGENTS(TIM5->PSC,TIM5_PSC, TIM5_CNT ,T_uint32le,1);
REGENTS(TIM5->ARR,TIM5_ARR, TIM5_PSC ,T_uint32le,1);
REGENTS(TIM5->CCR1,TIM5_CCR1, TIM5_ARR ,T_uint32le,1);
REGENTS(TIM5->CCR2,TIM5_CCR2, TIM5_CCR1 ,T_uint32le,1);
REGENTS(TIM5->CCR3,TIM5_CCR3, TIM5_CCR2 ,T_uint32le,1);
REGENTS(TIM5->CCR4,TIM5_CCR4, TIM5_CCR3 ,T_uint32le,1);
REGENTS(TIM5->BDTR,TIM5_BDTR, TIM5_CCR4 ,T_uint32le,1);
REGENTS(TIM5->DCR,TIM5_DCR, TIM5_BDTR ,T_uint32le,1);
REGENTS(TIM5->DMAR,TIM5_DMAR, TIM5_DCR ,T_uint32le,1);
REGENTS(TIM5->OR,TIM5_OR, TIM5_DMAR ,T_uint32le,1);

REGENTS(TIM9->CR1,TIM9_CR1,TIM5_OR	,T_uint32le,1);
REGENTS(TIM9->CR2,TIM9_CR2,TIM9_CR1	,T_uint32le,1);
REGENTS(TIM9->SMCR,TIM9_SMCR,TIM9_CR2	,T_uint32le,1);
REGENTS(TIM9->DIER,TIM9_DIER,TIM9_SMCR	,T_uint32le,1);
REGENTS(TIM9->SR,TIM9_SR,TIM9_DIER	,T_uint32le,1);
REGENTS(TIM9->EGR,TIM9_EGR, TIM9_SR	,T_uint32le,1);
REGENTS(TIM9->CCMR1,TIM9_CCMR1, TIM9_EGR ,T_uint32le,1);
REGENTS(TIM9->CCMR2,TIM9_CCMR2, TIM9_CCMR1 ,T_uint32le,1);
REGENTS(TIM9->CCER,TIM9_CCER, TIM9_CCMR2 ,T_uint32le,1);
REGENTS(TIM9->CNT,TIM9_CNT, TIM9_CCER ,T_uint32le,1);
REGENTS(TIM9->PSC,TIM9_PSC, TIM9_CNT ,T_uint32le,1);
REGENTS(TIM9->ARR,TIM9_ARR, TIM9_PSC ,T_uint32le,1);
REGENTS(TIM9->CCR1,TIM9_CCR1, TIM9_ARR ,T_uint32le,1);
REGENTS(TIM9->CCR2,TIM9_CCR2, TIM9_CCR1 ,T_uint32le,1);
REGENTS(TIM9->CCR3,TIM9_CCR3, TIM9_CCR2 ,T_uint32le,1);
REGENTS(TIM9->CCR4,TIM9_CCR4, TIM9_CCR3 ,T_uint32le,1);
REGENTS(TIM9->BDTR,TIM9_BDTR, TIM9_CCR4 ,T_uint32le,1);
REGENTS(TIM9->DCR,TIM9_DCR, TIM9_BDTR ,T_uint32le,1);
REGENTS(TIM9->DMAR,TIM9_DMAR, TIM9_DCR ,T_uint32le,1);
REGENTS(TIM9->OR,TIM9_OR, TIM9_DMAR ,T_uint32le,1);

REGENTS(TIM10->CR1,TIM10_CR1,TIM9_OR	,T_uint32le,1);
REGENTS(TIM10->CR2,TIM10_CR2,TIM10_CR1	,T_uint32le,1);
REGENTS(TIM10->SMCR,TIM10_SMCR,TIM10_CR2	,T_uint32le,1);
REGENTS(TIM10->DIER,TIM10_DIER,TIM10_SMCR	,T_uint32le,1);
REGENTS(TIM10->SR,TIM10_SR,TIM10_DIER	,T_uint32le,1);
REGENTS(TIM10->EGR,TIM10_EGR, TIM10_SR	,T_uint32le,1);
REGENTS(TIM10->CCMR1,TIM10_CCMR1, TIM10_EGR ,T_uint32le,1);
REGENTS(TIM10->CCMR2,TIM10_CCMR2, TIM10_CCMR1 ,T_uint32le,1);
REGENTS(TIM10->CCER,TIM10_CCER, TIM10_CCMR2 ,T_uint32le,1);
REGENTS(TIM10->CNT,TIM10_CNT, TIM10_CCER ,T_uint32le,1);
REGENTS(TIM10->PSC,TIM10_PSC, TIM10_CNT ,T_uint32le,1);
REGENTS(TIM10->ARR,TIM10_ARR, TIM10_PSC ,T_uint32le,1);
REGENTS(TIM10->CCR1,TIM10_CCR1, TIM10_ARR ,T_uint32le,1);
REGENTS(TIM10->CCR2,TIM10_CCR2, TIM10_CCR1 ,T_uint32le,1);
REGENTS(TIM10->CCR3,TIM10_CCR3, TIM10_CCR2 ,T_uint32le,1);
REGENTS(TIM10->CCR4,TIM10_CCR4, TIM10_CCR3 ,T_uint32le,1);
REGENTS(TIM10->BDTR,TIM10_BDTR, TIM10_CCR4 ,T_uint32le,1);
REGENTS(TIM10->DCR,TIM10_DCR, TIM10_BDTR ,T_uint32le,1);
REGENTS(TIM10->DMAR,TIM10_DMAR, TIM10_DCR ,T_uint32le,1);
REGENTS(TIM10->OR,TIM10_OR, TIM10_DMAR ,T_uint32le,1);

REGENTS(TIM11->CR1,TIM11_CR1,TIM10_OR	,T_uint32le,1);
REGENTS(TIM11->CR2,TIM11_CR2,TIM11_CR1	,T_uint32le,1);
REGENTS(TIM11->SMCR,TIM11_SMCR,TIM11_CR2	,T_uint32le,1);
REGENTS(TIM11->DIER,TIM11_DIER,TIM11_SMCR	,T_uint32le,1);
REGENTS(TIM11->SR,TIM11_SR,TIM11_DIER	,T_uint32le,1);
REGENTS(TIM11->EGR,TIM11_EGR, TIM11_SR	,T_uint32le,1);
REGENTS(TIM11->CCMR1,TIM11_CCMR1, TIM11_EGR ,T_uint32le,1);
REGENTS(TIM11->CCMR2,TIM11_CCMR2, TIM11_CCMR1 ,T_uint32le,1);
REGENTS(TIM11->CCER,TIM11_CCER, TIM11_CCMR2 ,T_uint32le,1);
REGENTS(TIM11->CNT,TIM11_CNT, TIM11_CCER ,T_uint32le,1);
REGENTS(TIM11->PSC,TIM11_PSC, TIM11_CNT ,T_uint32le,1);
REGENTS(TIM11->ARR,TIM11_ARR, TIM11_PSC ,T_uint32le,1);
REGENTS(TIM11->CCR1,TIM11_CCR1, TIM11_ARR ,T_uint32le,1);
REGENTS(TIM11->CCR2,TIM11_CCR2, TIM11_CCR1 ,T_uint32le,1);
REGENTS(TIM11->CCR3,TIM11_CCR3, TIM11_CCR2 ,T_uint32le,1);
REGENTS(TIM11->CCR4,TIM11_CCR4, TIM11_CCR3 ,T_uint32le,1);
REGENTS(TIM11->BDTR,TIM11_BDTR, TIM11_CCR4 ,T_uint32le,1);
REGENTS(TIM11->DCR,TIM11_DCR, TIM11_BDTR ,T_uint32le,1);
REGENTS(TIM11->DMAR,TIM11_DMAR, TIM11_DCR ,T_uint32le,1);
REGENTS(TIM11->OR,TIM11_OR, TIM11_DMAR ,T_uint32le,1);

REGENTS(RCC->CR,RCC_CR, TIM11_OR ,T_uint32le,1);
REGENTS(RCC->PLLCFGR,RCC_PLLCFGR, RCC_CR ,T_uint32le,1);
REGENTS(RCC->CFGR,RCC_CFGR, RCC_PLLCFGR ,T_uint32le,1);
REGENTS(RCC->CIR,RCC_CIR, RCC_CFGR ,T_uint32le,1);
REGENTS(RCC->AHB1RSTR,RCC_AHB1RSTR, RCC_CIR ,T_uint32le,1);
REGENTS(RCC->AHB2RSTR,RCC_AHB2RSTR, RCC_AHB1RSTR ,T_uint32le,1);
REGENTS(RCC->AHB3RSTR,RCC_AHB3RSTR, RCC_AHB2RSTR ,T_uint32le,1);
REGENTS(RCC->APB1RSTR,RCC_APB1RSTR, RCC_AHB3RSTR ,T_uint32le,1);
REGENTS(RCC->APB2RSTR,RCC_APB2RSTR, RCC_APB1RSTR ,T_uint32le,1);
REGENTS(RCC->AHB1ENR,RCC_AHB1ENR, RCC_APB2RSTR ,T_uint32le,1);
REGENTS(RCC->AHB2ENR,RCC_AHB2ENR, RCC_AHB1ENR ,T_uint32le,1);
REGENTS(RCC->AHB3ENR,RCC_AHB3ENR, RCC_AHB2ENR ,T_uint32le,1);
REGENTS(RCC->APB1ENR,RCC_APB1ENR, RCC_AHB3ENR ,T_uint32le,1);
REGENTS(RCC->APB2ENR,RCC_APB2ENR, RCC_APB1ENR ,T_uint32le,1);
REGENTS(RCC->AHB1LPENR,RCC_AHB1LPENR, RCC_APB2ENR ,T_uint32le,1);
REGENTS(RCC->AHB2LPENR,RCC_AHB2LPENR, RCC_AHB1LPENR ,T_uint32le,1);
REGENTS(RCC->AHB3LPENR,RCC_AHB3LPENR, RCC_AHB2LPENR ,T_uint32le,1);
REGENTS(RCC->APB1LPENR,RCC_APB1LPENR, RCC_AHB3LPENR ,T_uint32le,1);
REGENTS(RCC->APB2LPENR,RCC_APB2LPENR, RCC_APB1LPENR ,T_uint32le,1);
REGENTS(RCC->BDCR,RCC_BDCR, RCC_APB2LPENR ,T_uint32le,1);
REGENTS(RCC->CSR,RCC_CSR, RCC_BDCR ,T_uint32le,1);
REGENTS(RCC->SSCGR,RCC_SSCGR, RCC_CSR ,T_uint32le,1);
REGENTS(RCC->PLLI2SCFGR,RCC_PLLI2SCFGR, RCC_SSCGR ,T_uint32le,1);

REGENTS(PWR->CR,PWR_CR, RCC_PLLI2SCFGR ,T_uint32le,1);
REGENTS(PWR->CSR,PWR_CSR, PWR_CR ,T_uint32le,1);

REGENTS(SPI1->CR1,SPI1_CR1, PWR_CSR ,T_uint32le,1);
REGENTS(SPI1->CR2,SPI1_CR2, SPI1_CR1 ,T_uint32le,1);
REGENTS(SPI1->SR,SPI1_SR, SPI1_CR2 ,T_uint32le,1);
REGENTS(SPI1->DR,SPI1_DR, SPI1_SR ,T_uint32le,1);
REGENTS(SPI1->CRCPR,SPI1_CRCPR, SPI1_DR ,T_uint32le,1);
REGENTS(SPI1->RXCRCR,SPI1_RXCRCR, SPI1_CRCPR ,T_uint32le,1);
REGENTS(SPI1->TXCRCR,SPI1_TXCRCR, SPI1_RXCRCR ,T_uint32le,1);
REGENTS(SPI1->I2SCFGR,SPI1_I2SCFGR, SPI1_TXCRCR ,T_uint32le,1);
REGENTS(SPI1->I2SPR,SPI1_I2SPR, SPI1_I2SCFGR,T_uint32le,1);

REGENTS(SPI2->CR1,SPI2_CR1, SPI1_I2SPR ,T_uint32le,1);
REGENTS(SPI2->CR2,SPI2_CR2, SPI2_CR1 ,T_uint32le,1);
REGENTS(SPI2->SR,SPI2_SR, SPI2_CR2 ,T_uint32le,1);
REGENTS(SPI2->DR,SPI2_DR, SPI2_SR ,T_uint32le,1);
REGENTS(SPI2->CRCPR,SPI2_CRCPR, SPI2_DR ,T_uint32le,1);
REGENTS(SPI2->RXCRCR,SPI2_RXCRCR, SPI2_CRCPR ,T_uint32le,1);
REGENTS(SPI2->TXCRCR,SPI2_TXCRCR, SPI2_RXCRCR ,T_uint32le,1);
REGENTS(SPI2->I2SCFGR,SPI2_I2SCFGR, SPI2_TXCRCR ,T_uint32le,1);
REGENTS(SPI2->I2SPR,SPI2_I2SPR, SPI2_I2SCFGR,T_uint32le,1);

REGENTS(SPI3->CR1,SPI3_CR1, SPI2_I2SPR ,T_uint32le,1);
REGENTS(SPI3->CR2,SPI3_CR2, SPI3_CR1 ,T_uint32le,1);
REGENTS(SPI3->SR,SPI3_SR, SPI3_CR2 ,T_uint32le,1);
REGENTS(SPI3->DR,SPI3_DR, SPI3_SR ,T_uint32le,1);
REGENTS(SPI3->CRCPR,SPI3_CRCPR, SPI3_DR ,T_uint32le,1);
REGENTS(SPI3->RXCRCR,SPI3_RXCRCR, SPI3_CRCPR ,T_uint32le,1);
REGENTS(SPI3->TXCRCR,SPI3_TXCRCR, SPI3_RXCRCR ,T_uint32le,1);
REGENTS(SPI3->I2SCFGR,SPI3_I2SCFGR, SPI3_TXCRCR ,T_uint32le,1);
REGENTS(SPI3->I2SPR,SPI3_I2SPR, SPI3_I2SCFGR,T_uint32le,1);

REGENTS(USART1->SR,USART1_SR, SPI3_I2SPR,T_uint32le,1);
REGENTS(USART1->DR,USART1_DR, USART1_SR,T_uint32le,1);
REGENTS(USART1->BRR,USART1_BRR, USART1_DR,T_uint32le,1);
REGENTS(USART1->CR1,USART1_CR1, USART1_BRR,T_uint32le,1);
REGENTS(USART1->CR2,USART1_CR2, USART1_CR1,T_uint32le,1);
REGENTS(USART1->CR3,USART1_CR3, USART1_CR2,T_uint32le,1);
REGENTS(USART1->GTPR,USART1_GTPR, USART1_CR3,T_uint32le,1);

REGENTS(USART2->SR,USART2_SR, USART1_GTPR,T_uint32le,1);
REGENTS(USART2->DR,USART2_DR, USART2_SR,T_uint32le,1);
REGENTS(USART2->BRR,USART2_BRR, USART2_DR,T_uint32le,1);
REGENTS(USART2->CR1,USART2_CR1, USART2_BRR,T_uint32le,1);
REGENTS(USART2->CR2,USART2_CR2, USART2_CR1,T_uint32le,1);
REGENTS(USART2->CR3,USART2_CR3, USART2_CR2,T_uint32le,1);
REGENTS(USART2->GTPR,USART2_GTPR, USART2_CR3,T_uint32le,1);

REGENTS(ADC1_COMMON->CSR, ADC1_COMMON_CSR, USART2_GTPR ,T_uint32le,1);
REGENTS(ADC1_COMMON->CCR, ADC1_COMMON_CCR, ADC1_COMMON_CSR ,T_uint32le,1);

REGENTS(ADC1->SR, ADC1_SR, ADC1_COMMON_CCR ,T_uint32le,1);
REGENTS(ADC1->CR1,ADC1_CR1, ADC1_SR,T_uint32le,1);
REGENTS(ADC1->CR2,ADC1_CR2, ADC1_CR1,T_uint32le,1);
REGENTS(ADC1->SMPR1,ADC1_SMPR1, ADC1_CR2,T_uint32le,1);
REGENTS(ADC1->SMPR2,ADC1_SMPR2, ADC1_SMPR1,T_uint32le,1);
REGENTS(ADC1->JOFR1,ADC1_JOFR1, ADC1_SMPR2,T_uint32le,1);
REGENTS(ADC1->JOFR2,ADC1_JOFR2, ADC1_JOFR1,T_uint32le,1);
REGENTS(ADC1->JOFR3,ADC1_JOFR3, ADC1_JOFR2,T_uint32le,1);
REGENTS(ADC1->JOFR4,ADC1_JOFR4, ADC1_JOFR3,T_uint32le,1);
REGENTS(ADC1->HTR,ADC1_HTR, ADC1_JOFR4,T_uint32le,1);
REGENTS(ADC1->LTR,ADC1_LTR, ADC1_HTR,T_uint32le,1);
REGENTS(ADC1->SQR1,ADC1_SQR1, ADC1_LTR,T_uint32le,1);
REGENTS(ADC1->SQR2,ADC1_SQR2, ADC1_SQR1,T_uint32le,1);
REGENTS(ADC1->SQR3,ADC1_SQR3, ADC1_SQR2,T_uint32le,1);
REGENTS(ADC1->JSQR,ADC1_JSQR, ADC1_SQR3,T_uint32le,1);
REGENTS(ADC1->JDR1,ADC1_JDR1, ADC1_JSQR,T_uint32le,1);
REGENTS(ADC1->JDR2,ADC1_JDR2, ADC1_JDR1,T_uint32le,1);
REGENTS(ADC1->JDR3,ADC1_JDR3, ADC1_JDR2,T_uint32le,1);
REGENTS(ADC1->JDR4,ADC1_JDR4, ADC1_JDR3,T_uint32le,1);
REGENTS(ADC1->DR,ADC1_DR, ADC1_JDR4,T_uint32le,1);

REGENTS(I2C1->CR1,I2C1_CR1,ADC1_DR,T_uint32le,1);
REGENTS(I2C1->CR2,I2C1_CR2, I2C1_CR1,T_uint32le,1);
REGENTS(I2C1->OAR1,I2C1_OAR1, I2C1_CR2,T_uint32le,1);
REGENTS(I2C1->OAR2,I2C1_OAR2, I2C1_OAR1,T_uint32le,1);
REGENTS(I2C1->DR,I2C1_DR, I2C1_OAR2,T_uint32le,1);
REGENTS(I2C1->SR1,I2C1_SR1, I2C1_DR,T_uint32le,1);
REGENTS(I2C1->SR2,I2C1_SR2, I2C1_SR1,T_uint32le,1);
REGENTS(I2C1->CCR,I2C1_CCR, I2C1_SR2,T_uint32le,1);
REGENTS(I2C1->TRISE,I2C1_TRISE, I2C1_SR2,T_uint32le,1);

REGENTS(I2C2->CR1,I2C2_CR1, I2C1_TRISE,T_uint32le,1);
REGENTS(I2C2->CR2,I2C2_CR2, I2C2_CR1,T_uint32le,1);
REGENTS(I2C2->OAR1,I2C2_OAR1, I2C2_CR2,T_uint32le,1);
REGENTS(I2C2->OAR2,I2C2_OAR2, I2C2_OAR1,T_uint32le,1);
REGENTS(I2C2->DR,I2C2_DR, I2C2_OAR2,T_uint32le,1);
REGENTS(I2C2->SR1,I2C2_SR1, I2C2_DR,T_uint32le,1);
REGENTS(I2C2->SR2,I2C2_SR2, I2C2_SR1,T_uint32le,1);
REGENTS(I2C2->CCR,I2C2_CCR, I2C2_SR2,T_uint32le,1);
REGENTS(I2C2->TRISE,I2C2_TRISE, I2C2_SR2,T_uint32le,1);

REGENTS(I2C3->CR1,I2C3_CR1, I2C2_TRISE,T_uint32le,1);
REGENTS(I2C3->CR2,I2C3_CR2, I2C3_CR1,T_uint32le,1);
REGENTS(I2C3->OAR1,I2C3_OAR1, I2C3_CR2,T_uint32le,1);
REGENTS(I2C3->OAR2,I2C3_OAR2, I2C3_OAR1,T_uint32le,1);
REGENTS(I2C3->DR,I2C3_DR, I2C3_OAR2,T_uint32le,1);
REGENTS(I2C3->SR1,I2C3_SR1, I2C3_DR,T_uint32le,1);
REGENTS(I2C3->SR2,I2C3_SR2, I2C3_SR1,T_uint32le,1);
REGENTS(I2C3->CCR,I2C3_CCR, I2C3_SR2,T_uint32le,1);
REGENTS(I2C3->TRISE,I2C3_TRISE, I2C3_CCR,T_uint32le,1);

REGENTA(_DMA1_LISR 		,DMA1_LISR		,I2C3_TRISE,T_uint32le,1);
REGENTA(_DMA1_HISR 		,DMA1_HISR		,DMA1_LISR,T_uint32le,1);
REGENTA(_DMA1_LIFCR		,DMA1_LIFCR		,DMA1_HISR,T_uint32le,1);
REGENTA(_DMA1_HIFCR 	,DMA1_HIFCR		,DMA1_LIFCR,T_uint32le,1);

REGENTA(_DMA1_S0_CR 	,DMA1_S0_CR		,DMA1_HIFCR,T_uint32le,1);
REGENTA(_DMA1_S0_NDTR 	,DMA1_S0_NDTR	,DMA1_S0_CR,T_uint32le,1);
REGENTA(_DMA1_S0_PAR 	,DMA1_S0_PAR	,DMA1_S0_NDTR,T_uint32le,1);
REGENTA(_DMA1_S0_M0AR 	,DMA1_S0_M0AR	,DMA1_S0_PAR,T_uint32le,1);
REGENTA(_DMA1_S0_M1AR 	,DMA1_S0_M1AR	,DMA1_S0_M0AR,T_uint32le,1);
REGENTA(_DMA1_S0_FCR 	,DMA1_S0_FCR	,DMA1_S0_M1AR,T_uint32le,1);

REGENTA(_DMA1_S1_CR 	,DMA1_S1_CR		,DMA1_S0_FCR,T_uint32le,1);
REGENTA(_DMA1_S1_NDTR 	,DMA1_S1_NDTR	,DMA1_S1_CR,T_uint32le,1);
REGENTA(_DMA1_S1_PAR 	,DMA1_S1_PAR	,DMA1_S1_NDTR,T_uint32le,1);
REGENTA(_DMA1_S1_M0AR 	,DMA1_S1_M0AR	,DMA1_S1_PAR,T_uint32le,1);
REGENTA(_DMA1_S1_M1AR 	,DMA1_S1_M1AR	,DMA1_S1_M0AR,T_uint32le,1);
REGENTA(_DMA1_S1_FCR 	,DMA1_S1_FCR	,DMA1_S1_M1AR,T_uint32le,1);

REGENTA(_DMA1_S2_CR 	,DMA1_S2_CR		,DMA1_S1_FCR,T_uint32le,1);
REGENTA(_DMA1_S2_NDTR 	,DMA1_S2_NDTR	,DMA1_S2_CR,T_uint32le,1);
REGENTA(_DMA1_S2_PAR 	,DMA1_S2_PAR	,DMA1_S2_NDTR,T_uint32le,1);
REGENTA(_DMA1_S2_M0AR 	,DMA1_S2_M0AR	,DMA1_S2_PAR,T_uint32le,1);
REGENTA(_DMA1_S2_M1AR 	,DMA1_S2_M1AR	,DMA1_S2_M0AR,T_uint32le,1);
REGENTA(_DMA1_S2_FCR 	,DMA1_S2_FCR	,DMA1_S2_M1AR,T_uint32le,1);

REGENTA(_DMA1_S3_CR 	,DMA1_S3_CR		,DMA1_S2_FCR,T_uint32le,1);
REGENTA(_DMA1_S3_NDTR 	,DMA1_S3_NDTR	,DMA1_S3_CR,T_uint32le,1);
REGENTA(_DMA1_S3_PAR 	,DMA1_S3_PAR	,DMA1_S3_NDTR,T_uint32le,1);
REGENTA(_DMA1_S3_M0AR 	,DMA1_S3_M0AR	,DMA1_S3_PAR,T_uint32le,1);
REGENTA(_DMA1_S3_M1AR 	,DMA1_S3_M1AR	,DMA1_S3_M0AR,T_uint32le,1);
REGENTA(_DMA1_S3_FCR 	,DMA1_S3_FCR	,DMA1_S3_M1AR,T_uint32le,1);

REGENTA(_DMA1_S4_CR 	,DMA1_S4_CR		,DMA1_S3_FCR,T_uint32le,1);
REGENTA(_DMA1_S4_NDTR 	,DMA1_S4_NDTR	,DMA1_S4_CR,T_uint32le,1);
REGENTA(_DMA1_S4_PAR 	,DMA1_S4_PAR	,DMA1_S4_NDTR,T_uint32le,1);
REGENTA(_DMA1_S4_M0AR 	,DMA1_S4_M0AR	,DMA1_S4_PAR,T_uint32le,1);
REGENTA(_DMA1_S4_M1AR 	,DMA1_S4_M1AR	,DMA1_S4_M0AR,T_uint32le,1);
REGENTA(_DMA1_S4_FCR 	,DMA1_S4_FCR	,DMA1_S4_M1AR,T_uint32le,1);

REGENTA(_DMA1_S5_CR 	,DMA1_S5_CR		,DMA1_S4_FCR,T_uint32le,1);
REGENTA(_DMA1_S5_NDTR 	,DMA1_S5_NDTR	,DMA1_S5_CR,T_uint32le,1);
REGENTA(_DMA1_S5_PAR 	,DMA1_S5_PAR	,DMA1_S5_NDTR,T_uint32le,1);
REGENTA(_DMA1_S5_M0AR 	,DMA1_S5_M0AR	,DMA1_S5_PAR,T_uint32le,1);
REGENTA(_DMA1_S5_M1AR 	,DMA1_S5_M1AR	,DMA1_S5_M0AR,T_uint32le,1);
REGENTA(_DMA1_S5_FCR 	,DMA1_S5_FCR	,DMA1_S5_M1AR,T_uint32le,1);

REGENTA(_DMA1_S6_CR 	,DMA1_S6_CR		,DMA1_S5_FCR,T_uint32le,1);
REGENTA(_DMA1_S6_NDTR 	,DMA1_S6_NDTR	,DMA1_S6_CR,T_uint32le,1);
REGENTA(_DMA1_S6_PAR 	,DMA1_S6_PAR	,DMA1_S6_NDTR,T_uint32le,1);
REGENTA(_DMA1_S6_M0AR 	,DMA1_S6_M0AR	,DMA1_S6_PAR,T_uint32le,1);
REGENTA(_DMA1_S6_M1AR 	,DMA1_S6_M1AR	,DMA1_S6_M0AR,T_uint32le,1);
REGENTA(_DMA1_S6_FCR 	,DMA1_S6_FCR	,DMA1_S6_M1AR,T_uint32le,1);

REGENTA(_DMA1_S7_CR 	,DMA1_S7_CR		,DMA1_S6_FCR,T_uint32le,1);
REGENTA(_DMA1_S7_NDTR 	,DMA1_S7_NDTR	,DMA1_S7_CR,T_uint32le,1);
REGENTA(_DMA1_S7_PAR 	,DMA1_S7_PAR	,DMA1_S7_NDTR,T_uint32le,1);
REGENTA(_DMA1_S7_M0AR 	,DMA1_S7_M0AR	,DMA1_S7_PAR,T_uint32le,1);
REGENTA(_DMA1_S7_M1AR 	,DMA1_S7_M1AR	,DMA1_S7_M0AR,T_uint32le,1);
REGENTA(_DMA1_S7_FCR 	,DMA1_S7_FCR	,DMA1_S7_M1AR,T_uint32le,1);

REGENTA(_DMA2_LISR 		,DMA2_LISR		,DMA1_S7_FCR,T_uint32le,1);
REGENTA(_DMA2_HISR 		,DMA2_HISR		,DMA2_LISR,T_uint32le,1);
REGENTA(_DMA2_LIFCR		,DMA2_LIFCR		,DMA2_HISR,T_uint32le,1);
REGENTA(_DMA2_HIFCR 	,DMA2_HIFCR		,DMA2_LIFCR,T_uint32le,1);

REGENTA(_DMA2_S0_CR 	,DMA2_S0_CR		,DMA2_HIFCR,T_uint32le,1);
REGENTA(_DMA2_S0_NDTR 	,DMA2_S0_NDTR	,DMA2_S0_CR,T_uint32le,1);
REGENTA(_DMA2_S0_PAR 	,DMA2_S0_PAR	,DMA2_S0_NDTR,T_uint32le,1);
REGENTA(_DMA2_S0_M0AR 	,DMA2_S0_M0AR	,DMA2_S0_PAR,T_uint32le,1);
REGENTA(_DMA2_S0_M1AR 	,DMA2_S0_M1AR	,DMA2_S0_M0AR,T_uint32le,1);
REGENTA(_DMA2_S0_FCR 	,DMA2_S0_FCR	,DMA2_S0_M1AR,T_uint32le,1);

REGENTA(_DMA2_S1_CR 	,DMA2_S1_CR		,DMA2_S0_FCR,T_uint32le,1);
REGENTA(_DMA2_S1_NDTR 	,DMA2_S1_NDTR	,DMA2_S1_CR,T_uint32le,1);
REGENTA(_DMA2_S1_PAR 	,DMA2_S1_PAR	,DMA2_S1_NDTR,T_uint32le,1);
REGENTA(_DMA2_S1_M0AR 	,DMA2_S1_M0AR	,DMA2_S1_PAR,T_uint32le,1);
REGENTA(_DMA2_S1_M1AR 	,DMA2_S1_M1AR	,DMA2_S1_M0AR,T_uint32le,1);
REGENTA(_DMA2_S1_FCR 	,DMA2_S1_FCR	,DMA2_S1_M1AR,T_uint32le,1);

REGENTA(_DMA2_S2_CR 	,DMA2_S2_CR		,DMA2_S1_FCR,T_uint32le,1);
REGENTA(_DMA2_S2_NDTR 	,DMA2_S2_NDTR	,DMA2_S2_CR,T_uint32le,1);
REGENTA(_DMA2_S2_PAR 	,DMA2_S2_PAR	,DMA2_S2_NDTR,T_uint32le,1);
REGENTA(_DMA2_S2_M0AR 	,DMA2_S2_M0AR	,DMA2_S2_PAR,T_uint32le,1);
REGENTA(_DMA2_S2_M1AR 	,DMA2_S2_M1AR	,DMA2_S2_M0AR,T_uint32le,1);
REGENTA(_DMA2_S2_FCR 	,DMA2_S2_FCR	,DMA2_S2_M1AR,T_uint32le,1);

REGENTA(_DMA2_S3_CR 	,DMA2_S3_CR		,DMA2_S2_FCR,T_uint32le,1);
REGENTA(_DMA2_S3_NDTR 	,DMA2_S3_NDTR	,DMA2_S3_CR,T_uint32le,1);
REGENTA(_DMA2_S3_PAR 	,DMA2_S3_PAR	,DMA2_S3_NDTR,T_uint32le,1);
REGENTA(_DMA2_S3_M0AR 	,DMA2_S3_M0AR	,DMA2_S3_PAR,T_uint32le,1);
REGENTA(_DMA2_S3_M1AR 	,DMA2_S3_M1AR	,DMA2_S3_M0AR,T_uint32le,1);
REGENTA(_DMA2_S3_FCR 	,DMA2_S3_FCR	,DMA2_S3_M1AR,T_uint32le,1);

REGENTA(_DMA2_S4_CR 	,DMA2_S4_CR		,DMA2_S3_FCR,T_uint32le,1);
REGENTA(_DMA2_S4_NDTR 	,DMA2_S4_NDTR	,DMA2_S4_CR,T_uint32le,1);
REGENTA(_DMA2_S4_PAR 	,DMA2_S4_PAR	,DMA2_S4_NDTR,T_uint32le,1);
REGENTA(_DMA2_S4_M0AR 	,DMA2_S4_M0AR	,DMA2_S4_PAR,T_uint32le,1);
REGENTA(_DMA2_S4_M1AR 	,DMA2_S4_M1AR	,DMA2_S4_M0AR,T_uint32le,1);
REGENTA(_DMA2_S4_FCR 	,DMA2_S4_FCR	,DMA2_S4_M1AR,T_uint32le,1);

REGENTA(_DMA2_S5_CR 	,DMA2_S5_CR		,DMA2_S4_FCR,T_uint32le,1);
REGENTA(_DMA2_S5_NDTR 	,DMA2_S5_NDTR	,DMA2_S5_CR,T_uint32le,1);
REGENTA(_DMA2_S5_PAR 	,DMA2_S5_PAR	,DMA2_S5_NDTR,T_uint32le,1);
REGENTA(_DMA2_S5_M0AR 	,DMA2_S5_M0AR	,DMA2_S5_PAR,T_uint32le,1);
REGENTA(_DMA2_S5_M1AR 	,DMA2_S5_M1AR	,DMA2_S5_M0AR,T_uint32le,1);
REGENTA(_DMA2_S5_FCR 	,DMA2_S5_FCR	,DMA2_S5_M1AR,T_uint32le,1);

REGENTA(_DMA2_S6_CR 	,DMA2_S6_CR		,DMA2_S5_FCR,T_uint32le,1);
REGENTA(_DMA2_S6_NDTR 	,DMA2_S6_NDTR	,DMA2_S6_CR,T_uint32le,1);
REGENTA(_DMA2_S6_PAR 	,DMA2_S6_PAR	,DMA2_S6_NDTR,T_uint32le,1);
REGENTA(_DMA2_S6_M0AR 	,DMA2_S6_M0AR	,DMA2_S6_PAR,T_uint32le,1);
REGENTA(_DMA2_S6_M1AR 	,DMA2_S6_M1AR	,DMA2_S6_M0AR,T_uint32le,1);
REGENTA(_DMA2_S6_FCR 	,DMA2_S6_FCR	,DMA2_S6_M1AR,T_uint32le,1);

REGENTA(_DMA2_S7_CR 	,DMA2_S7_CR		,DMA2_S6_FCR,T_uint32le,1);
REGENTA(_DMA2_S7_NDTR 	,DMA2_S7_NDTR	,DMA2_S7_CR,T_uint32le,1);
REGENTA(_DMA2_S7_PAR 	,DMA2_S7_PAR	,DMA2_S7_NDTR,T_uint32le,1);
REGENTA(_DMA2_S7_M0AR 	,DMA2_S7_M0AR	,DMA2_S7_PAR,T_uint32le,1);
REGENTA(_DMA2_S7_M1AR 	,DMA2_S7_M1AR	,DMA2_S7_M0AR,T_uint32le,1);
REGENTA(_DMA2_S7_FCR 	,DMA2_S7_FCR	,DMA2_S7_M1AR,T_uint32le,1);
REGENTA(_DBGMCU_IDCODE	,DBGMCU_IDCODE	,DMA2_S7_FCR,T_uint32le,1);

REGENT(DMA_Buffer_0,DBGMCU_IDCODE,T_uint8,1);
REGENT(ADC_DMA_Buffer,DMA_Buffer_0,T_uint8,1);
REGENT(DAC_DMA_Buffer,ADC_DMA_Buffer,T_uint8,1);

REGENT(SystemCoreClock,DAC_DMA_Buffer,T_uint32le,1);
REGENT(DeviceName,  SystemCoreClock,T_string, 1);
REGENT(ADC1_CAL,  DeviceName,T_float32le, 1);

REGENT(ETH_Dropped_Packets,	ADC1_CAL,T_uint32le,1);
REGENT(ETH_ARP_Responses,	ETH_Dropped_Packets,T_uint32le ,1);
REGENT(ETH_ICMP_Responses,	ETH_ARP_Responses,T_uint32le ,1);
REGENT(ETH_UDP_Xmits,		ETH_ICMP_Responses,T_uint32le ,1);
REGENT(ETH_ENC_Resets,		ETH_UDP_Xmits,T_uint32le ,1);
REGENT(ETH_ENC_Tx_Resets,	ETH_ENC_Resets,T_uint32le ,1);



REGENT(IPConfig,			ETH_ENC_Tx_Resets,T_uint8,1);

REGENT(IPConfigF,			IPConfig,T_uint8,1);

REGENTS(IPConfig.FPCons, 	FPCons,		IPConfigF,T_float32le,1);
REGENTS(IPConfig.AutoStart,	AutoStart,	FPCons,T_uint32le,1);
REGENTS(IPConfig.PartSerno, PartSerno,	AutoStart,T_uint32le,1);
REGENTS(IPConfig.StartUp, 	StartUp,	PartSerno,T_uint8,1);



REGENT(Screen,				StartUp,		T_string,SCREEN_COLS);
REGENT(Test_sint8,	    	Screen,       	T_sint8 ,3);
REGENT(Test_uint8,		    Test_sint8,   	T_uint8 ,3);
REGENT(Test_sint16le,		Test_uint8,   	T_sint16le ,3);
REGENT(Test_uint16le,		Test_sint16le,	T_uint16le ,3);
REGENT(Test_sint32le,		Test_uint16le,T_sint32le ,3);
REGENT(Test_uint32le,		Test_sint32le,T_uint32le ,3);
REGENT(Test_float32le,		Test_uint32le,T_float32le ,3);
REGENT(Reg_Name,			Test_float32le,T_uint8,1);

RegEnt * RegistryFindByName(char * Name)
{
 RegEnt * R;
 R=(RegEnt*)&Reg_Reg_Name;
 while((strcmp(Name,R->name)!=0)&&(R->next!=0)) R=R->next;
 if (R->next==0) R= (RegEnt *)0;
 return R;
}

