/*
 * stypes.h
 *
 *  Created on: Aug 3, 2023
 *      Author: ianst
 */

#ifndef INC_STYPES_H_
#define INC_STYPES_H_
typedef union _uint8_t_VAL
{
    uint8_t Val;
    struct
    {
        uint8_t b0:1;
        uint8_t b1:1;
        uint8_t b2:1;
        uint8_t b3:1;
        uint8_t b4:1;
        uint8_t b5:1;
        uint8_t b6:1;
        uint8_t b7:1;
    } bits;
} uint8_t_VAL, uint8_t_BITS;

typedef union _uint16_t_VAL
{
    uint16_t Val;
    uint8_t v[2];
    struct
    {
        uint8_t LB;
        uint8_t HB;
    } byte;
    struct
    {
        uint8_t b0:1;
        uint8_t b1:1;
        uint8_t b2:1;
        uint8_t b3:1;
        uint8_t b4:1;
        uint8_t b5:1;
        uint8_t b6:1;
        uint8_t b7:1;
        uint8_t b8:1;
        uint8_t b9:1;
        uint8_t b10:1;
        uint8_t b11:1;
        uint8_t b12:1;
        uint8_t b13:1;
        uint8_t b14:1;
        uint8_t b15:1;
    } bits;
} uint16_t_VAL, uint16_t_BITS;

typedef union _uint32_t_VAL
{
    uint32_t Val;
	uint16_t w[2];
    uint8_t v[4];
    struct
    {
        uint16_t LW;
        uint16_t HW;
    } word;
    struct
    {
        uint8_t LB;
        uint8_t HB;
        uint8_t UB;
        uint8_t MB;
    } byte;
    struct
    {
        uint16_t_VAL low;
        uint16_t_VAL high;
    }wordUnion;
    struct
    {
        uint8_t b0:1;
        uint8_t b1:1;
        uint8_t b2:1;
        uint8_t b3:1;
        uint8_t b4:1;
        uint8_t b5:1;
        uint8_t b6:1;
        uint8_t b7:1;
        uint8_t b8:1;
        uint8_t b9:1;
        uint8_t b10:1;
        uint8_t b11:1;
        uint8_t b12:1;
        uint8_t b13:1;
        uint8_t b14:1;
        uint8_t b15:1;
        uint8_t b16:1;
        uint8_t b17:1;
        uint8_t b18:1;
        uint8_t b19:1;
        uint8_t b20:1;
        uint8_t b21:1;
        uint8_t b22:1;
        uint8_t b23:1;
        uint8_t b24:1;
        uint8_t b25:1;
        uint8_t b26:1;
        uint8_t b27:1;
        uint8_t b28:1;
        uint8_t b29:1;
        uint8_t b30:1;
        uint8_t b31:1;
    } bits;
} uint32_t_VAL;

typedef struct __attribute__((__packed__)) _MAC_ADDR
{
    uint8_t v[6];
} MAC_ADDR;

#define IP_ADDR		uint32_t_VAL



#endif /* INC_STYPES_H_ */
