/*
 * setup.h
 *
 *  Created on: Jan 2, 2021
 *      Author: ianst
 */

#ifndef INC_SETUP_H_
#define INC_SETUP_H_


//Scheduler reload value in uS
#define SCHEDULER_T0_PERIOD 100

#if defined(STM32F401xC)
//device and configuration  specific setup
// Resources used
// Systick Timer
// Timer 3 - Task0 Period
// LED - GPIOC13

// for ENC28J60 Ethernet
// CS 	-GPIOB13 AF0
// CLK 	-GPIOB10 AF5
// MISO	-GPIOB14 AF5
// MOSI	-GPIOB15 AF5
// SPI 2
// DMA1 Channel 0 Stream 3
// DMA1 Channel 0 Stream 4
#define DEVICE_NAME "STM32F401CC\0"
#define TICKS_PER_US (84)
#define CYCLES_PER_US (84)   //CPU

#define CPU_PLL_N_DIVISOR (168)
#define INIT_APB1CLKDivider RCC_HCLK_DIV2
#define INIT_APB2CLKDivider RCC_HCLK_DIV1

//ENC28J60 connected via spi2
#define SPI_ENC_P SPI2

#define ENC_CS_IO			(GPIOB->ODR)
#define ENC_CS_PIN GPIO_PIN_13
#define ENC_CS_GPIO_PORT 	GPIOB
#define ENABLE_ENC_CS  		ENC_CS_GPIO_PORT->MODER |= GPIO_MODER_MODER13_0;

#define ENC_CS_HIGH 	Wait_N_Cycles((CYCLES_PER_US*210)/1000 ); 	ENC_CS_GPIO_PORT->BSRR = (ENC_CS_PIN)
#define ENC_CS_LOW 		ENC_CS_GPIO_PORT->BSRR = (ENC_CS_PIN<<16); 	Wait_N_Cycles((CYCLES_PER_US*50)/1000 )


#define ENC_ETH_DMA_RX_COMPLETE (DMA1->LISR&DMA_LISR_TCIF3)  // stm32f401 - spi2 - S3
#define RCC_APB1ENR_SPI_ENCEN RCC_APB1ENR_SPI2EN
#define GPIO_AF_SPI_ENC 	GPIO_AF5_SPI2
#define ENC_GPIO_PINS 		(GPIO_PIN_10|GPIO_PIN_14|GPIO_PIN_15)
#define ENC_GPIO_PORT 		GPIOB

#define ENC_RX_DMA_STREAM DMA1_Stream3   // stm32f401
#define ENC_RX_DMA_CHANNEL 	DMA_CHANNEL_0
#define ENC_TX_DMA_STREAM DMA1_Stream4    // stm32f401
#define ENC_TX_DMA_CHANNEL 	DMA_CHANNEL_0

#define FLASH_CONFIG_SECTOR_NO  1
#define FLASH_CONFIG_SECTOR_BLOCKSIZE (16384l)
//#define DEVICE_FLASH_LATENCY (FLASH_LATENCY_2)



#define LED_PORT GPIOC
#define LED_PIN (GPIO_PIN_13)
#define ENABLE_LED_DRIVER GPIOC->MODER |= GPIO_MODER_MODER13_0

#define FLASH_THE_LED if ((LED_PORT->ODR&LED_PIN)>0) LED_PORT->BSRR = (LED_PIN<<16); else  LED_PORT->BSRR = (LED_PIN);

#define SCHEDULER_TIMER TIM4// note - if you want to change this - then grepping for T4 will be required - particularly inc scheduler

#endif //defined(STM32F401xC)


#if defined(STM32F411xC)
//device and configuration  specific setup
// Resources used
// Systick Timer
// Timer 3 - Task0 Period
// LED - GPIOC13

// for ENC28J60 Ethernet
// CS 	-GPIOB13 AF0
// CLK 	-GPIOB10 AF5
// MISO	-GPIOB14 AF5
// MOSI	-GPIOB15 AF5
// SPI 2
// DMA1 Channel 0 Stream 3
// DMA1 Channel 0 Stream 4
#define DEVICE_NAME "STM32F411CE\0"
#define TICKS_PER_US (100)
#define CYCLES_PER_US (100)   //CPU
#define DEVICE_FLASH_LATENCY FLASH_LATENCY_2
#define HSE_VALUE (25000000l)
#define CPU_PLL_N_DIVISOR (168)
#define INIT_APB1CLKDivider RCC_HCLK_DIV2
#define INIT_APB2CLKDivider RCC_HCLK_DIV1
#define SPI_ENC SPI2   //ENC28J60 connected via spi2
#define ENABLE_LED_DRIVER GPIOC->MODER |= GPIO_MODER_MODER13_0
#define ENABLE_ENC_CS  GPIOB->MODER |= GPIO_MODER_MODER13_0
#define ENC_CS_IO			(GPIOB->ODR)
#define ENC_CS_HIGH 	Wait_N_Cycles((CYCLES_PER_US*210)/1000 ); 	ENC_CS_GPIO_PORT->BSRR = (ENC_CS_PIN)
#define ENC_CS_LOW 		ENC_CS_GPIO_PORT->BSRR = (ENC_CS_PIN<<16); 	Wait_N_Cycles((CYCLES_PER_US*50)/1000 )
#define ENC_ETH_DMA_RX_COMPLETE (DMA1->LISR&DMA_LISR_TCIF3)  // stm32f401 - spi2 - S3
#define RCC_APB1ENR_SPI_ENCEN RCC_APB1ENR_SPI2EN
#define GPIO_AF_SPI_ENC 	GPIO_AF5_SPI2
#define ENC_GPIO_PINS 		(GPIO_PIN_10|GPIO_PIN_14|GPIO_PIN_15)
#define ENC_GPIO_PORT 		GPIOB
#define ENC_RX_DMA_STREAM DMA1_Stream3   // stm32f401
#define ENC_RX_DMA_CHANNEL 	DMA_CHANNEL_0
#define ENC_TX_DMA_STREAM DMA1_Stream4    // stm32f401
#define ENC_TX_DMA_CHANNEL 	DMA_CHANNEL_0
#define FLASH_CONFIG_SECTOR_NO  1
#define FLASH_CONFIG_SECTOR_BLOCKSIZE (16384l)
#define LED_PORT GPIOC
#define LED_PIN (GPIO_PIN_13)
#define FLASH_THE_LED if ((LED_PORT->ODR&LED_PIN)>0) LED_PORT->BSRR = (LED_PIN<<16); else  LED_PORT->BSRR = (LED_PIN);
#endif //defined(STM32F401xC)


#if defined(STM32F407xx)
//device and configuration  specific setup
// Resources used
// Systick Timer 	- Instrumentation and code delays
// Timer 3 			- Task0 Period
// LED GPIOA06

// for ENC28J60 Ethernet
// CS 	-GPIOA12 AF0
// CLK 	-GPIOC10 AF6
// MISO	-GPIOC11 AF6
// MOSI	-GPIOC12 AF6
// SPI3
// DMA1 Channel 0 Stream 0
// DMA1 Channel 0 Stream 5
#define DEVICE_NAME "STM32F407VE\0"
#define TICKS_PER_US (84)  // for TIM3
#define CYCLES_PER_US (168)   //CPU
#define DEVICE_FLASH_LATENCY (FLASH_LATENCY_5)
#define HSE_VALUE (8000000l)
#define INIT_APB1CLKDivider RCC_HCLK_DIV4
#define INIT_APB2CLKDivider RCC_HCLK_DIV2
//#define SPI_ENC SPI3
#define SPI_ENC_P SPI2
#define CPU_PLL_N_DIVISOR (168*2)
#define ENABLE_LED_DRIVER GPIOA->MODER |= GPIO_MODER_MODER6_0
#define ENABLE_ENC_CS  GPIOA->MODER |= GPIO_MODER_MODER12_0
#define ENC_CS_IO			(GPIOA->ODR)
#define ENC_CS_HIGH ENC_CS_IO |= (1<<12)
#define ENC_CS_LOW ENC_CS_IO &= ~(1<<12)
#define RCC_APB1ENR_SPI_ENCEN RCC_APB1ENR_SPI3EN
#define GPIO_AF_SPI_ENC 	GPIO_AF6_SPI3
#define ENC_GPIO_PINS 		(GPIO_PIN_10|GPIO_PIN_11|GPIO_PIN_12)
#define ENC_GPIO_PORT 		GPIOC
#define ENC_ETH_DMA_RX_COMPLETE (DMA1->LISR&DMA_LISR_TCIF0)
#define ENC_TX_DMA_CHANNEL 	DMA_CHANNEL_0
#define ENC_TX_DMA_STREAM DMA1_Stream5
#define ENC_RX_DMA_CHANNEL 	DMA_CHANNEL_0
#define ENC_RX_DMA_STREAM DMA1_Stream0
#define FLASH_CONFIG_SECTOR_NO  1
#define FLASH_CONFIG_SECTOR_BLOCKSIZE (16384l)
#define FLASH_THE_LED GPIOA->ODR ^= (1 << 6)
#endif //defined(STM32F407xx)

#define EXTAL_OSC_FREQ (HSE_VALUE/1000000l)
#define SCHEDULER_TIMER_RELOAD_VALUE ((TICKS_PER_US*SHEDULER_T0_PERIOD)-1)

void RCC_ClockConfig(RCC_ClkInitTypeDef  *RCC_ClkInitStruct, uint32_t FLatency);
uint32_t RCC_GetSysClockFreq(void);
void RCC_OscConfig(RCC_OscInitTypeDef  *RCC_OscInitStruct);
void GPIO_Init(GPIO_TypeDef  *GPIOx, GPIO_InitTypeDef *GPIO_Init);
void Setup(void);
extern uint32_t sysclockfreq;

#endif /* INC_SETUP_H_ */
