/*
 * scheduler.h
 *
 *  Created on: Jan 2, 2021
 *      Author: ianst
 */

#ifndef SCHEDULER_H_
#define SCHEDULER_H_

#include "stdint.h"
#include "main.h"
#include "armbits.h"

#include "ianENC28J60.h"


/* Exported types ------------------------------------------------------------*/
/* USER CODE BEGIN ET */

struct TaskCtlTag
{
	volatile uint32_t  	InTask;
	volatile uint32_t  	ReEntryCount;
	volatile uint32_t    CallCount;
	volatile int32_t 	MinTimeInTask;
	volatile int32_t 	MaxTimeInTask;
	volatile uint32_t  	DownRatio;
	volatile uint32_t  	DownCounter;
			void (*ThisTask)(void);
			void *NextTaskCtl;
	volatile int32_t 	LastTime;
	volatile int32_t 	TaskPeriod;
	volatile int32_t 	TimeInTask;
};
typedef struct TaskCtlTag TaskCtl;


/* USER CODE END ET */

/* Exported functions prototypes ---------------------------------------------*/
void Error_Handler(void);
void TaskPrint(TaskCtl * T,uint32_t n);
void Wait_N_uS(uint32_t uS);
void Wait_N_Cycles(uint32_t Cycles);
void Wait_N_100nS(uint32_t N);
//debug void SPI_Init(SPI_HandleTypeDef *hspi);
void Setup(void);
void DoTask(TaskCtl * T, uint32_t Told);
void Task0(void);
void Task1(void);
void Task2(void);
void Task3(void);
void Task4(void);
void Task5(void);
void Task6(void);
void Task7(void);
void Task8(void);
void Task9(void);
void scheduler_setup(void);
void main_loop(void);
void PrintTasks(void);
uint32_t timextnd(void);

/* USER CODE END Includes */



/* Exported constants --------------------------------------------------------*/
/* USER CODE BEGIN EC */
#define SCREEN_ROWS (25)
#define SCREEN_COLS (50)
#define DMA_Buffer_0_Size (8192)

extern char Screen[SCREEN_ROWS*SCREEN_COLS];

#define SCHEDULER_JITTER (48) // Jitter protection is currently broken - causes hang on reset I do not know why - Fixed - scheduler shield


extern TaskCtl  TaskCtl9;
extern TaskCtl  TaskCtl8;
extern TaskCtl  TaskCtl7;
extern TaskCtl  TaskCtl6;
extern TaskCtl  TaskCtl5;
extern TaskCtl  TaskCtl4;
extern TaskCtl  TaskCtl3;
extern TaskCtl  TaskCtl2;
extern TaskCtl  TaskCtl1;
extern TaskCtl  TaskCtl0;

extern volatile uint32_t  T32;
extern volatile uint32_t Initialised;
extern  volatile uint32_t SchedulerShield;





#define DMA_DISABLE(__HANDLE__)     ((__HANDLE__)->Instance->CR &=  ~DMA_SxCR_EN)
#define DMA_ENABLE(__HANDLE__)      ((__HANDLE__)->Instance->CR |=  DMA_SxCR_EN)


#define SHEDULER_T0_PERIOD (20)     //microseconds
#define SCHEDULER_TIMER_RELOAD_VALUE ((TICKS_PER_US*SHEDULER_T0_PERIOD)-1)

#define hdma_spi_enc_rx hdma_spi2_rx
#define hdma_spi_enc_tx hdma_spi2_tx

extern DMA_HandleTypeDef hdma_spi_enc_rx;
extern DMA_HandleTypeDef hdma_spi_enc_tx;
extern char DeviceName[21];

extern __IO uint32_t uwTick;
/* USER CODE BEGIN EFP */


#endif /* SCHEDULER_H_ */
