/*
 * registry.h
 *
 *  Created on: Jan 2, 2021
 *      Author: ianst
 */

#ifndef REGISTRY_H_
#define REGISTRY_H_

#include "stdint.h"


#define T_uint8 0
#define T_sint8 1
#define T_uint16le 2
#define T_sint16le 3
#define T_uint32le 4
#define T_sint32le 5
#define T_float32le 6
#define T_complex32le 7
#define T_float64le 8
#define T_complex64le 9
#define T_string 10
#define T_null 11

typedef struct PEEKTag
{
 unsigned int type[2];
} PEEK;

#define REGNAMELEN 32
typedef struct RegEntTag
{
 void * next;
 void * ptr;
 unsigned int len;
 unsigned int rows;
 unsigned int type;
 char name [REGNAMELEN];
} RegEnt;

extern const RegEnt Reg_Reg_Name;


#define QUOTEME(x) #x
#define ADROF(x) &x
#define REGENT(x,next,type,b_per_col) const RegEnt Reg_##x ={(void *) ADROF(Reg_##next) , (void*)ADROF(x) , sizeof(x) , b_per_col , type , QUOTEME(x)}
#define REGENTS(x,xn,next,type,b_per_col) const RegEnt Reg_##xn ={(void *) ADROF(Reg_##next) , (void*)ADROF(x) , sizeof(x) , b_per_col , type , QUOTEME(xn)}
#define REGENTA(x,xn,next,type,b_per_col) const RegEnt Reg_##xn ={(void *) ADROF(Reg_##next) , (void*)(x) , sizeof(uint32_t) , b_per_col , type , QUOTEME(xn)}


RegEnt * RegistryFindByName(char * Name);

#define ADC_DMA_Buffer_Size (16384*4)
#define DAC_DMA_Buffer_Size (32768)
extern uint8_t ADC_DMA_Buffer[ADC_DMA_Buffer_Size];

#endif /* REGISTRY_H_ */
