/*
 * config.h
 *
 *  Created on: Nov 30, 2022
 *      Author: ianst
 */

#ifndef INC_CONFIG_H_
#define INC_CONFIG_H_
#include "stdint.h"
#include "stypes.h"


typedef struct __attribute__((__packed__)) _IP_CONFIG
{
	IP_ADDR		MyIPAddr;
	IP_ADDR		MyMask;
	IP_ADDR		MyGateway;
	IP_ADDR		PrimaryDNSServer;
	IP_ADDR		SecondaryDNSServer;
	MAC_ADDR	MyMACAddr;
} IP_CONFIG;

/*
 format for config
 List_Type
 Command addr(32) length(16) data(8).....
 Command addr(32) length(16) data(8).....
 Command addr(32) length(16) data(8).....

 note data is lsb first - little endian

 Command
  0 end of list
  1 write
  2 bit set
  3 not and (bit clear)
  255 List Type 1
*/
#define CONFIG_END_OF_LIST (0)
#define CONFIG_WRITE (1)
#define CONFIG_BIT_SET (2)
#define CONFIG_BIT_CLEAR (3)
#define CONFIG_LIST_TYPE_1 (255)

#define StartUpSize (1024*10)
typedef struct __attribute__((__packed__))  _CONFIGPAGE
{
 IP_CONFIG IP;
 float FPCons[8];
 uint32_t AutoStart;
 uint32_t PartSerno[2];
 uint8_t StartUp[StartUpSize];
} CONFIGPAGE;

extern IP_CONFIG IPC_Local;
extern const CONFIGPAGE IPConfigF;
extern  CONFIGPAGE IPConfig;

void StartUpConfig(void);
#endif /* INC_CONFIG_H_ */
