/*
 * armbits.h
 *
 *  Created on: Jan 2, 2021
 *      Author: ianst
 */

#ifndef INC_ARMBITS_H_
#define INC_ARMBITS_H_
#include "stm32f4xx.h"
#include "stdint.h"


#define EXTAL_OSC_FREQ (HSE_VALUE/1000000l)
#define TICKS_PER_US (100)  // TIM4
#define CYCLES_PER_US (100)   //CPU
#define FLASH_CONFIG_SECTOR_NO  1
#define FLASH_CONFIG_SECTOR_BLOCKSIZE (16384l)
#define SCHEDULER_TIMER TIM4


#define DEVICE_FLASH_LATENCY (FLASH_LATENCY_2)
#define SPI_ENC_P SPI2


#define LED_PORT GPIOC
#define LED_PIN (GPIO_PIN_13)
#define SCHED_TIM TIM4  // note - if you want to change this - then grepping for T4 will be required - particularly inc scheduler

#define ENABLE_LED_DRIVER GPIOC->CRH |= (GPIO_CRH_MODE13_0|GPIO_CRH_MODE13_1)

#define ENC_GPIO_PINS 		(GPIO_PIN_10|GPIO_PIN_14|GPIO_PIN_15)  // clk miso mosi
#define ENC_GPIO_PORT 		GPIOB
#define ENC_CS_GPIO_PORT 	GPIOB
#define ENC_RS_GPIO_PORT 	GPIOB
#define STM_RS_GPIO_PORT 	GPIOC
#define ENC_CS_PIN GPIO_PIN_13
#define ENC_RS_PIN GPIO_PIN_12
#define STM_RS_PIN GPIO_PIN_15
#define ENABLE_ENC_CS  		ENC_CS_GPIO_PORT->CRH |= (GPIO_CRH_MODE13_0|GPIO_CRH_MODE13_1)

#define ENC_CS_HIGH 	Wait_N_Cycles((CYCLES_PER_US*210)/1000 ); 	ENC_CS_GPIO_PORT->BSRR = (ENC_CS_PIN)
#define ENC_CS_LOW 		ENC_CS_GPIO_PORT->BSRR = (ENC_CS_PIN<<16); 	Wait_N_Cycles((CYCLES_PER_US*50)/1000 )

#define ENC_RS_HIGH 	Wait_N_Cycles((CYCLES_PER_US*2500)/1000 ); 	ENC_RS_GPIO_PORT->BSRR = (ENC_RS_PIN)
#define ENC_RS_LOW 		ENC_RS_GPIO_PORT->BSRR = (ENC_RS_PIN<<16); 	Wait_N_Cycles((CYCLES_PER_US*50) )
//#define ENC_ETH_DMA_RX_COMPLETE (DMA1->LISR&DMA_LISR_TCIF3)
#define ENC_ETH_DMA_RX_COMPLETE (((DMA1->LISR&DMA_LISR_TCIF3)>0)&&((SPI_ENC_P->SR&SPI_SR_BSY)==0))

#define STM_RS_LOW 	 	STM_RS_GPIO_PORT->BSRR = (STM_RS_PIN<<16); Wait_N_Cycles((CYCLES_PER_US*2500)/1000 )

#define DEVICE_NAME "STM32F411CEU6\0"
#define ENC_RX_DMA_CHANNEL 	DMA1_Channel3
#define ENC_TX_DMA_CHANNEL  DMA1_Channel4


#define FLASH_THE_LED if ((LED_PORT->ODR&LED_PIN)>0) LED_PORT->BSRR = (LED_PIN<<16); else  LED_PORT->BSRR = (LED_PIN);


typedef struct _DMAC_TypeDef
{   DMA_TypeDef *       DMA;
	DMA_Stream_TypeDef * S0;
	DMA_Stream_TypeDef * S1;
	DMA_Stream_TypeDef * S2;
	DMA_Stream_TypeDef * S3;
	DMA_Stream_TypeDef * S4;
	DMA_Stream_TypeDef * S5;
	DMA_Stream_TypeDef * S6;
	DMA_Stream_TypeDef * S7;
}DMAC_TypeDef;




#define DMA_CHANNEL_0                 0x00000000U    /*!< DMA Channel 0 */
#define DMA_CHANNEL_1                 0x02000000U    /*!< DMA Channel 1 */
#define DMA_CHANNEL_2                 0x04000000U    /*!< DMA Channel 2 */
#define DMA_CHANNEL_3                 0x06000000U    /*!< DMA Channel 3 */
#define DMA_CHANNEL_4                 0x08000000U    /*!< DMA Channel 4 */
#define DMA_CHANNEL_5                 0x0A000000U    /*!< DMA Channel 5 */
#define DMA_CHANNEL_6                 0x0C000000U    /*!< DMA Channel 6 */
#define DMA_CHANNEL_7                 0x0E000000U    /*!< DMA Channel 7 */
#if defined (DMA_SxCR_CHSEL_3)
#define DMA_CHANNEL_8                 0x10000000U    /*!< DMA Channel 8 */
#define DMA_CHANNEL_9                 0x12000000U    /*!< DMA Channel 9 */
#define DMA_CHANNEL_10                0x14000000U    /*!< DMA Channel 10 */
#define DMA_CHANNEL_11                0x16000000U    /*!< DMA Channel 11 */
#define DMA_CHANNEL_12                0x18000000U    /*!< DMA Channel 12 */
#define DMA_CHANNEL_13                0x1A000000U    /*!< DMA Channel 13 */
#define DMA_CHANNEL_14                0x1C000000U    /*!< DMA Channel 14 */
#define DMA_CHANNEL_15                0x1E000000U    /*!< DMA Channel 15 */
#endif /* DMA_SxCR_CHSEL_3 */

#define _DBGMCU_IDCODE  (DBGMCU_BASE)
#define _UID_BASE   (UID_BASE)
/*-------------------------------------------
 * -------------------------------------------------------------------*/
// Definitions for Registry
#define _DMA1_LISR  		DMA1_BASE+offsetof(DMA_TypeDef,LISR)
#define _DMA1_HISR  		DMA1_BASE+offsetof(DMA_TypeDef,HISR)
#define _DMA1_LIFCR 		DMA1_BASE+offsetof(DMA_TypeDef,LIFCR)
#define _DMA1_HIFCR 		DMA1_BASE+offsetof(DMA_TypeDef,HIFCR)

#define _DMA1_S0_CR 	DMA1_Stream0_BASE+offsetof(DMA_Stream_TypeDef,CR)
#define _DMA1_S0_NDTR 	DMA1_Stream0_BASE+offsetof(DMA_Stream_TypeDef,NDTR)
#define _DMA1_S0_PAR 	DMA1_Stream0_BASE+offsetof(DMA_Stream_TypeDef,PAR)
#define _DMA1_S0_M0AR 	DMA1_Stream0_BASE+offsetof(DMA_Stream_TypeDef,M0AR)
#define _DMA1_S0_M1AR 	DMA1_Stream0_BASE+offsetof(DMA_Stream_TypeDef,M1AR)
#define _DMA1_S0_FCR  	DMA1_Stream0_BASE+offsetof(DMA_Stream_TypeDef,FCR)

#define _DMA1_S1_CR 	DMA1_Stream1_BASE+offsetof(DMA_Stream_TypeDef,CR)
#define _DMA1_S1_NDTR 	DMA1_Stream1_BASE+offsetof(DMA_Stream_TypeDef,NDTR)
#define _DMA1_S1_PAR 	DMA1_Stream1_BASE+offsetof(DMA_Stream_TypeDef,PAR)
#define _DMA1_S1_M0AR 	DMA1_Stream1_BASE+offsetof(DMA_Stream_TypeDef,M0AR)
#define _DMA1_S1_M1AR 	DMA1_Stream1_BASE+offsetof(DMA_Stream_TypeDef,M1AR)
#define _DMA1_S1_FCR  	DMA1_Stream1_BASE+offsetof(DMA_Stream_TypeDef,FCR)

#define _DMA1_S2_CR 	DMA1_Stream2_BASE+offsetof(DMA_Stream_TypeDef,CR)
#define _DMA1_S2_NDTR 	DMA1_Stream2_BASE+offsetof(DMA_Stream_TypeDef,NDTR)
#define _DMA1_S2_PAR 	DMA1_Stream2_BASE+offsetof(DMA_Stream_TypeDef,PAR)
#define _DMA1_S2_M0AR 	DMA1_Stream2_BASE+offsetof(DMA_Stream_TypeDef,M0AR)
#define _DMA1_S2_M1AR 	DMA1_Stream2_BASE+offsetof(DMA_Stream_TypeDef,M1AR)
#define _DMA1_S2_FCR  	DMA1_Stream2_BASE+offsetof(DMA_Stream_TypeDef,FCR)

#define _DMA1_S3_CR 	DMA1_Stream3_BASE+offsetof(DMA_Stream_TypeDef,CR)
#define _DMA1_S3_NDTR 	DMA1_Stream3_BASE+offsetof(DMA_Stream_TypeDef,NDTR)
#define _DMA1_S3_PAR 	DMA1_Stream3_BASE+offsetof(DMA_Stream_TypeDef,PAR)
#define _DMA1_S3_M0AR 	DMA1_Stream3_BASE+offsetof(DMA_Stream_TypeDef,M0AR)
#define _DMA1_S3_M1AR 	DMA1_Stream3_BASE+offsetof(DMA_Stream_TypeDef,M1AR)
#define _DMA1_S3_FCR  	DMA1_Stream3_BASE+offsetof(DMA_Stream_TypeDef,FCR)

#define _DMA1_S4_CR 	DMA1_Stream4_BASE+offsetof(DMA_Stream_TypeDef,CR)
#define _DMA1_S4_NDTR 	DMA1_Stream4_BASE+offsetof(DMA_Stream_TypeDef,NDTR)
#define _DMA1_S4_PAR 	DMA1_Stream4_BASE+offsetof(DMA_Stream_TypeDef,PAR)
#define _DMA1_S4_M0AR 	DMA1_Stream4_BASE+offsetof(DMA_Stream_TypeDef,M0AR)
#define _DMA1_S4_M1AR 	DMA1_Stream4_BASE+offsetof(DMA_Stream_TypeDef,M1AR)
#define _DMA1_S4_FCR  	DMA1_Stream4_BASE+offsetof(DMA_Stream_TypeDef,FCR)

#define _DMA1_S5_CR 	DMA1_Stream5_BASE+offsetof(DMA_Stream_TypeDef,CR)
#define _DMA1_S5_NDTR 	DMA1_Stream5_BASE+offsetof(DMA_Stream_TypeDef,NDTR)
#define _DMA1_S5_PAR 	DMA1_Stream5_BASE+offsetof(DMA_Stream_TypeDef,PAR)
#define _DMA1_S5_M0AR 	DMA1_Stream5_BASE+offsetof(DMA_Stream_TypeDef,M0AR)
#define _DMA1_S5_M1AR 	DMA1_Stream5_BASE+offsetof(DMA_Stream_TypeDef,M1AR)
#define _DMA1_S5_FCR  	DMA1_Stream5_BASE+offsetof(DMA_Stream_TypeDef,FCR)

#define _DMA1_S6_CR 	DMA1_Stream6_BASE+offsetof(DMA_Stream_TypeDef,CR)
#define _DMA1_S6_NDTR 	DMA1_Stream6_BASE+offsetof(DMA_Stream_TypeDef,NDTR)
#define _DMA1_S6_PAR 	DMA1_Stream6_BASE+offsetof(DMA_Stream_TypeDef,PAR)
#define _DMA1_S6_M0AR 	DMA1_Stream6_BASE+offsetof(DMA_Stream_TypeDef,M0AR)
#define _DMA1_S6_M1AR 	DMA1_Stream6_BASE+offsetof(DMA_Stream_TypeDef,M1AR)
#define _DMA1_S6_FCR  	DMA1_Stream6_BASE+offsetof(DMA_Stream_TypeDef,FCR)

#define _DMA1_S7_CR 	DMA1_Stream7_BASE+offsetof(DMA_Stream_TypeDef,CR)
#define _DMA1_S7_NDTR 	DMA1_Stream7_BASE+offsetof(DMA_Stream_TypeDef,NDTR)
#define _DMA1_S7_PAR 	DMA1_Stream7_BASE+offsetof(DMA_Stream_TypeDef,PAR)
#define _DMA1_S7_M0AR 	DMA1_Stream7_BASE+offsetof(DMA_Stream_TypeDef,M0AR)
#define _DMA1_S7_M1AR 	DMA1_Stream7_BASE+offsetof(DMA_Stream_TypeDef,M1AR)
#define _DMA1_S7_FCR  	DMA1_Stream7_BASE+offsetof(DMA_Stream_TypeDef,FCR)

#define _DMA2_LISR  		DMA2_BASE+offsetof(DMA_TypeDef,LISR)
#define _DMA2_HISR  		DMA2_BASE+offsetof(DMA_TypeDef,HISR)
#define _DMA2_LIFCR 		DMA2_BASE+offsetof(DMA_TypeDef,LIFCR)
#define _DMA2_HIFCR 		DMA2_BASE+offsetof(DMA_TypeDef,HIFCR)


#define _DMA2_S0_CR 	DMA2_Stream0_BASE+offsetof(DMA_Stream_TypeDef,CR)
#define _DMA2_S0_NDTR 	DMA2_Stream0_BASE+offsetof(DMA_Stream_TypeDef,NDTR)
#define _DMA2_S0_PAR 	DMA2_Stream0_BASE+offsetof(DMA_Stream_TypeDef,PAR)
#define _DMA2_S0_M0AR 	DMA2_Stream0_BASE+offsetof(DMA_Stream_TypeDef,M0AR)
#define _DMA2_S0_M1AR 	DMA2_Stream0_BASE+offsetof(DMA_Stream_TypeDef,M1AR)
#define _DMA2_S0_FCR  	DMA2_Stream0_BASE+offsetof(DMA_Stream_TypeDef,FCR)

#define _DMA2_S1_CR 	DMA2_Stream1_BASE+offsetof(DMA_Stream_TypeDef,CR)
#define _DMA2_S1_NDTR 	DMA2_Stream1_BASE+offsetof(DMA_Stream_TypeDef,NDTR)
#define _DMA2_S1_PAR 	DMA2_Stream1_BASE+offsetof(DMA_Stream_TypeDef,PAR)
#define _DMA2_S1_M0AR 	DMA2_Stream1_BASE+offsetof(DMA_Stream_TypeDef,M0AR)
#define _DMA2_S1_M1AR 	DMA2_Stream1_BASE+offsetof(DMA_Stream_TypeDef,M1AR)
#define _DMA2_S1_FCR  	DMA2_Stream1_BASE+offsetof(DMA_Stream_TypeDef,FCR)

#define _DMA2_S2_CR 	DMA2_Stream2_BASE+offsetof(DMA_Stream_TypeDef,CR)
#define _DMA2_S2_NDTR 	DMA2_Stream2_BASE+offsetof(DMA_Stream_TypeDef,NDTR)
#define _DMA2_S2_PAR 	DMA2_Stream2_BASE+offsetof(DMA_Stream_TypeDef,PAR)
#define _DMA2_S2_M0AR 	DMA2_Stream2_BASE+offsetof(DMA_Stream_TypeDef,M0AR)
#define _DMA2_S2_M1AR 	DMA2_Stream2_BASE+offsetof(DMA_Stream_TypeDef,M1AR)
#define _DMA2_S2_FCR  	DMA2_Stream2_BASE+offsetof(DMA_Stream_TypeDef,FCR)

#define _DMA2_S3_CR 	DMA2_Stream3_BASE+offsetof(DMA_Stream_TypeDef,CR)
#define _DMA2_S3_NDTR 	DMA2_Stream3_BASE+offsetof(DMA_Stream_TypeDef,NDTR)
#define _DMA2_S3_PAR 	DMA2_Stream3_BASE+offsetof(DMA_Stream_TypeDef,PAR)
#define _DMA2_S3_M0AR 	DMA2_Stream3_BASE+offsetof(DMA_Stream_TypeDef,M0AR)
#define _DMA2_S3_M1AR 	DMA2_Stream3_BASE+offsetof(DMA_Stream_TypeDef,M1AR)
#define _DMA2_S3_FCR  	DMA2_Stream3_BASE+offsetof(DMA_Stream_TypeDef,FCR)

#define _DMA2_S4_CR 	DMA2_Stream4_BASE+offsetof(DMA_Stream_TypeDef,CR)
#define _DMA2_S4_NDTR 	DMA2_Stream4_BASE+offsetof(DMA_Stream_TypeDef,NDTR)
#define _DMA2_S4_PAR 	DMA2_Stream4_BASE+offsetof(DMA_Stream_TypeDef,PAR)
#define _DMA2_S4_M0AR 	DMA2_Stream4_BASE+offsetof(DMA_Stream_TypeDef,M0AR)
#define _DMA2_S4_M1AR 	DMA2_Stream4_BASE+offsetof(DMA_Stream_TypeDef,M1AR)
#define _DMA2_S4_FCR  	DMA2_Stream4_BASE+offsetof(DMA_Stream_TypeDef,FCR)

#define _DMA2_S5_CR 	DMA2_Stream5_BASE+offsetof(DMA_Stream_TypeDef,CR)
#define _DMA2_S5_NDTR 	DMA2_Stream5_BASE+offsetof(DMA_Stream_TypeDef,NDTR)
#define _DMA2_S5_PAR 	DMA2_Stream5_BASE+offsetof(DMA_Stream_TypeDef,PAR)
#define _DMA2_S5_M0AR 	DMA2_Stream5_BASE+offsetof(DMA_Stream_TypeDef,M0AR)
#define _DMA2_S5_M1AR 	DMA2_Stream5_BASE+offsetof(DMA_Stream_TypeDef,M1AR)
#define _DMA2_S5_FCR  	DMA2_Stream5_BASE+offsetof(DMA_Stream_TypeDef,FCR)

#define _DMA2_S6_CR 	DMA2_Stream6_BASE+offsetof(DMA_Stream_TypeDef,CR)
#define _DMA2_S6_NDTR 	DMA2_Stream6_BASE+offsetof(DMA_Stream_TypeDef,NDTR)
#define _DMA2_S6_PAR 	DMA2_Stream6_BASE+offsetof(DMA_Stream_TypeDef,PAR)
#define _DMA2_S6_M0AR 	DMA2_Stream6_BASE+offsetof(DMA_Stream_TypeDef,M0AR)
#define _DMA2_S6_M1AR 	DMA2_Stream6_BASE+offsetof(DMA_Stream_TypeDef,M1AR)
#define _DMA2_S6_FCR  	DMA2_Stream6_BASE+offsetof(DMA_Stream_TypeDef,FCR)

#define _DMA2_S7_CR 	DMA2_Stream7_BASE+offsetof(DMA_Stream_TypeDef,CR)
#define _DMA2_S7_NDTR 	DMA2_Stream7_BASE+offsetof(DMA_Stream_TypeDef,NDTR)
#define _DMA2_S7_PAR 	DMA2_Stream7_BASE+offsetof(DMA_Stream_TypeDef,PAR)
#define _DMA2_S7_M0AR 	DMA2_Stream7_BASE+offsetof(DMA_Stream_TypeDef,M0AR)
#define _DMA2_S7_M1AR 	DMA2_Stream7_BASE+offsetof(DMA_Stream_TypeDef,M1AR)
#define _DMA2_S7_FCR  	DMA2_Stream7_BASE+offsetof(DMA_Stream_TypeDef,FCR)



#endif /* INC_ARMBITS_H_ */
