/*
 * TCPIPConfig.h
 *
 *  Created on: Jan 2, 2021
 *      Author: ianst
 */

#ifndef TCPIPCONFIG_H_
#define TCPIPCONFIG_H_

// =======================================================================
//   Network Address
// =======================================================================

#define MACIPLSB						(14)
#define MACIPNLSB						(1)
#define MY_DEFAULT_MAC_BYTE1            (0x00)
#define MY_DEFAULT_MAC_BYTE2            (0x04)
#define MY_DEFAULT_MAC_BYTE3            (0xA3)
#define MY_DEFAULT_MAC_BYTE4            (0x00)
#define MY_DEFAULT_MAC_BYTE5            (MACIPNLSB)
#define MY_DEFAULT_MAC_BYTE6            (MACIPLSB)

#define MY_DEFAULT_IP_ADDR_BYTE1        (192)
#define MY_DEFAULT_IP_ADDR_BYTE2        (168)
#define MY_DEFAULT_IP_ADDR_BYTE3        (MACIPNLSB)
#define MY_DEFAULT_IP_ADDR_BYTE4        (MACIPLSB)

#define MY_DEFAULT_MASK_BYTE1           (255)
#define MY_DEFAULT_MASK_BYTE2           (255)
#define MY_DEFAULT_MASK_BYTE3           (255)
#define MY_DEFAULT_MASK_BYTE4           (0)

#define MY_DEFAULT_GATE_BYTE1           (0)
#define MY_DEFAULT_GATE_BYTE2           (0)
#define MY_DEFAULT_GATE_BYTE3           (0)
#define MY_DEFAULT_GATE_BYTE4           (0)

#define MY_DEFAULT_PRIMARY_DNS_BYTE1	(0)
#define MY_DEFAULT_PRIMARY_DNS_BYTE2	(0)
#define MY_DEFAULT_PRIMARY_DNS_BYTE3	(0)
#define MY_DEFAULT_PRIMARY_DNS_BYTE4	(0)

#define MY_DEFAULT_SECONDARY_DNS_BYTE1	(0)
#define MY_DEFAULT_SECONDARY_DNS_BYTE2	(0)
#define MY_DEFAULT_SECONDARY_DNS_BYTE3	(0)
#define MY_DEFAULT_SECONDARY_DNS_BYTE4	(0)


#define MAX_ETHTX (1518)


#define MAX_UDP_PAYLOAD (MAX_ETHTX-(sizeof(IP_HEADER)+sizeof(UDP_HEADER)+sizeof(ENC_PREAMBLE)+sizeof(uint16_t)+sizeof(uint32_t)))  // This should be a multiple of 4 to allow 32 bit align 1080, 1040 seems to not cause enc tx resets - i do not know why
//#define MAX_ETHTX (MAX_UDP_PAYLOAD+sizeof(IP_HEADER)+sizeof(UDP_HEADER)+sizeof(ENC_PREAMBLE)+sizeof(uint16_t)+sizeof(uint32_t))



#endif /* TCPIPCONFIG_H_ */
